﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.IO;

namespace ModulePair {
    [Serializable]
    public class ModulesManager {
        public List<Device> DeviceStore = new List<Device>();
        public List<Device> DevicePool = new List<Device>();
        public UserConfig userConfig = new UserConfig();
        public Probes ProbStore;
        //public List<Probes> ProbePool = new List<Probes>();
        public List<Tower> TowerPool = new List<Tower>();

        public ModulesManager() {
        

            Prepare();

        }

        public ModulesManager Clone() {
            // Not Completed
            ModulesManager newModuleMan = new ModulesManager();
            foreach ( Device d in DevicePool ) {
                newModuleMan.DevicePool.Add( d.Clone() );
            }
            foreach ( Tower t in TowerPool ) {
                newModuleMan.TowerPool.Add( t.Clone() );
            }

            // newModuleMan.userConfig = userConfig.PairedList.
            newModuleMan.userConfig = userConfig.Clone();
            
            return newModuleMan;

        }
        public void Prepare() {


            ////Test ProbeConfig Create
            ////Per Tower

            ////Prepare Config
            //UserConfig userConfig = new UserConfig();
            ////Gen the pair of Config
            //UserConfig.Module module = new UserConfig.Module();
            //userConfig.ModuleList.Add( module );

            


            // Prepare Device Choice




            //                      

            ProbStore = FileManagement.FileManagement.ReadFromXmlFile<Probes>( @"Pb\Pbs.dx" );

            string[] devFiles = Directory.GetFiles( @"Dev\" );

            foreach ( string fileName in devFiles.Where(name =>name.EndsWith(".dvx")) ) {
                Device device = FileManagement.FileManagement.ReadFromXmlFile<Device>( fileName );

                foreach ( Device.Registers.Register r in device.RegistersList ) {
                    r.OwnerDevice = device;
                }

                DeviceStore.Add( device );

            }
        }

        public void UpdateStore() {

            ProbStore = FileManagement.FileManagement.ReadFromXmlFile<Probes>( @"Pb\Pbs.dx" );

            string[] devFiles = Directory.GetFiles( @"Dev\" );

            DeviceStore.Clear();

            foreach ( string fileName in devFiles.Where( name => name.EndsWith( ".dvx" ) ) ) {
                Device device = FileManagement.FileManagement.ReadFromXmlFile<Device>( fileName );

                foreach ( Device.Registers.Register r in device.RegistersList ) {
                    r.OwnerDevice = device;
                }
                DeviceStore.Add( device );
                
                

            }
        }

        public void AddModule( int TowerIndex , Probes.Probe Probe , Device Device , Device.Registers.Register Register ) {

            UserConfig.Module module = new UserConfig.Module();
            module.DeviceIndex = (byte)DeviceStore.IndexOf( Device );
            module.RegisterIndex = Register.Address;
            module.GroupIndex = (byte)TowerIndex;
            //module.ProbeIndex = 0;
            userConfig.ModuleList.Add( module );
        }

        public void RemoveModule( UserConfig.Module Module ) {

            userConfig.ModuleList.Remove( Module );
        }

        public void RemoveModuleAt( int Index ) {

            userConfig.ModuleList.RemoveAt( Index );
        }

        public void AddTower( string Name ,string ID) {
            //Do When Added the Tower

            //Device copied = (Device)DeviceStore[0].Clone();
            //copied.Name = DevicePool.Count + " - " + copied.Name;
            //DevicePool.Add( copied );
            //ProbePool.Add( (Probes)ProbStore.Clone() );

            
            Tower tower = new Tower( Name ,(Probes)ProbStore.Clone());
            tower.ID = ID;
            foreach ( Probes.Probe pb in tower.ProbePool.ProbesList ) {
                pb.OwnerTower = tower;
            }

            this.TowerPool.Add( tower);
            tower.Number = TowerPool.IndexOf( tower ) + 1;
            
        }
        public void AddDevice(string Name,Device Source) {
            Device device = (Device)Source.Clone();
            device.RegistersList.OwnerDevice = device;
            device.Alias = Name;
            //device.Name = Source.Name + "_" + (new Random().Next(500000));
            DevicePool.Add( device );
                
        }

        public void RemoveDevice( Device device ) {

            ClearBindings( device );
            DevicePool.Remove( device );
        }

        public void RemoveTower( Tower tower ) {
            

            ClearBindings( tower );
            TowerPool.Remove( tower );
        }

        public bool ClearBindings( Tower tower ) {

            if ( tower != null ) {

                foreach ( ModulePair.UserConfig.Paired paired in userConfig.PairedList.Where( paired => paired.Tower == tower ).ToList() ) {

                    userConfig.RemovePaired( paired );
                }
                return true;
            }
            return false;
        }

        public bool ClearBindings(Device device ) {

            if ( device != null ) {

                foreach ( ModulePair.UserConfig.Paired paired in userConfig.PairedList.Where( paired => paired.Device == device ).ToList() ) {

                    userConfig.RemovePaired( paired );
                }
                return true;
            }
            return false;
        }

    }
}
